#!/bin/bash -x
set -x
#
# build_toolchains.sh
# Shell script for building toolchains required for GNUCOBOL
# in MSYS2 MINGW32/mingw32  
#
# ==> this function builds the required dependencies via pacman
#     instead of installing them from source code.
#
100_build_toolchain_x32 ()  {
#
pacman -Rs        --noconfirm     \
    mingw-w64-i686-gcc            \
    mingw-w64-i686-lcov           \
    mingw-w64-i686-cjson          \
    mingw-w64-i686-gettext        \
    mingw-w64-i686-gmp            \
    mingw-w64-i686-gdb            \
    mingw-w64-i686-python-pygments  \
    mingw-w64-i686-libxml2        \
    mingw-w64-x86_64-gcc          \
    mingw-w64-x86_64-lcov         \
    mingw-w64-x86_64-cjson        \
    mingw-w64-x86_64-gettext      \
    mingw-w64-x86_64-gmp          \
    mingw-w64-x86_64-gdb          \
    mingw-w64-x86_64-python-pygments  \
    mingw-w64-x86_64-libxml2
#
#
pacman -Rs --noconfirm mingw-w64-x86_64-db
#
#
pacman -Rs --noconfirm mingw-w64-i686-db
#
#
ls /mingw32
rm -rf /mingw32/*
ls -R /mingw32
#
ls /mingw64
rm -rf /mingw64/*
ls -R /mingw64
pacman -Sc --noconfirm
#
pacman -S --noconfirm          \
 subversion                    \
 autotools                     \
 dos2unix                      \
 wget                          \
 git                           \
 vim                           \
 p7zip                         \
 make                          \
 unzip                         \
 bison                         \
 flex                          \
 texinfo                       \
 help2man                      \
 mingw-w64-i686-gcc            \
 mingw-w64-i686-lcov           \
 mingw-w64-i686-cjson          \
 mingw-w64-i686-gettext        \
 mingw-w64-i686-gmp            \
 mingw-w64-i686-gdb            \
 mingw-w64-i686-python-pygments  \
 mingw-w64-i686-libxml2        \
 mingw-w64-x86_64-gcc          \
 mingw-w64-x86_64-lcov         \
 mingw-w64-x86_64-cjson        \
 mingw-w64-x86_64-gettext      \
 mingw-w64-x86_64-gmp          \
 mingw-w64-x86_64-gdb          \
 mingw-w64-x86_64-python-pygments  \
 mingw-w64-x86_64-libxml2
#
    while ! rm -f -r  $HOME/X32 ;
    do
        echo 'rm X32 failed, sleeping for 5 seconds'
        sleep 5
        echo 'retrying...'
    done
#
    while ! rm -f -r  $HOME/X64 ;
    do
        echo 'rm X32 failed, sleeping for 5 seconds'
        sleep 5
        echo 'retrying...'
    done
#
    while ! rm -f -r  $HOME/*.txt ;
    do
        echo 'rm X32 failed, sleeping for 5 seconds'
        sleep 5
        echo 'retrying...'
    done
echo " Done installing dependencies in toolchain !! "
#
}
#   call function to build toolchain dependencies
start_time=$(date)
echo "@@start time      $start_time"
100_build_toolchain_x32
toolchain_time32=$(date)
echo "@@toolchain32       $toolchain_time32"
#

echo "@@start time      $start_time"
echo "@@toolchain32       $toolchain_time32"
