#!/bin/bash -x
#
#   Note that this is the Production script with performance optimization enabled !!
#       PROD x32 (32-bit)
    set -x
    if [[ -z $1 ]];
    then
        echo ' the required first input parm is missing '
        read -t 1 -n 10000 discard
        read -p "Press any key to continue... " -n1 -s
        exit 900
    else
        export ISAM=$1
    fi
    if [[ -z $2 ]];
    then
        echo ' the required second input parm is missing '
        read -t 1 -n 10000 discard
        read -p "Press any key to continue... " -n1 -s
        exit 900
    else
        export BUILD=$2
    fi
    cd $HOME
    mkdir x32
    cd x32
    export X32=$PWD
#
    export cpu_count=4
    export svn_checkout="checkout --config-option config:miscellany:use-commit-times=yes "
#
#-------->>> use this env variable for pdcurses Release 4.3.5
#
#   export svn_pdcurses="https://github.com/Bill-Gray/PDCursesMod.git/tags/v4.3.5 pdcurses-r435"
#
#-------->>> use this env variable for pdcurses TRUNK
#
#   export svn_pdcurses="https://github.com/Bill-Gray/PDCursesMod.git/trunk pdcurses-trunk"
#
#
#-------->>> use this env variable for pdcurses TRUNK
#
#   export svn_pdcurses="-r 3718 https://github.com/Bill-Gray/PDCursesMod.git/trunk pdcurses-commit-3718"
#
#
#
#
#-------->>> use this env variable for GNUCOBOL most current commit
#
    export svn_gnucobol="https://svn.code.sf.net/p/gnucobol/code/branches/gnucobol-3.x  gnucobol-trunk"
#
#-------->>> use this env variable for a specific commit of GNUCBOBOL
#-------->>> change "nnnn" to the commit you wish to download
#
#   export svn_gnucobol="-r nnnn https://svn.code.sf.net/p/gnucobol/code/branches/gnucobol-3.x  gnucobol-nnnn"
#
#
#-------->>> use this env variable for a specific RELEASE of GNUCBOBOL
#-------->>> change the tags name to the one you wish to download
#-------->>>            check in svn to check the actual tagname
#
#   export svn_gnucobol="https://svn.code.sf.net/p/gnucobol/code/tags/gnucobol-3.2-rc2  gnucobol-3.2rc2"
#
#
#
#-------->>> use this env variable for GCSORT most current commit
#
    export svn_gcsort="https://svn.code.sf.net/p/gnucobol/contrib/trunk/tools/GCSORT  gcsort"
#
#-------->>> use this env variable for a specific commit of GNUCBOBOL
#-------->>> change "nnnn" to the commit you wish to download
#
#   export svn_gcsort="-r nnnn https://svn.code.sf.net/p/gnucobol/contrib/trunk/tools/GCSORT  gcsort"
#
#
#
# build_x32.sh
# Shell script for building GNUCOBOL
# in MSYS2 MINGW32/mingw32
#
#
# ==> this function builds pdcursesmod from the most current
#     source code. Note that it builds both WINCON & WINGUI
#
200_build_pdcurses () {
    cd $X32
# ----> first remove existing directory for HOME
    rm -f -r  pd*
    git clone https://github.com/Bill-Gray/PDCursesMod.git       pdcurses-trunk
#   svn $svn_checkout $svn_pdcurses
    RESULT=$?
    if [ $RESULT -ne 0 ]; then
        echo ' the SVN command failed with return code of ' $RESULT
        read -t 1 -n 10000 discard
        read -p "Press any key to continue... " -n1 -s
        exit 910
    fi
#
#  ---> now repeat for WINGUI
#
    cd $X32
    cd pdc*             # note changes
#   cp -f /F/GNUCOBOL_SOURCE/curses.h               .
    cd $X32
    cd pdc*/wingui      # note changes
#   cp -f /C/msys64prep/patches/pdcscrn.c .
    make -j$cpu_count -f Makefile INFOEX=Y CHTYPE_64=Y DLL=Y CFLAGS='-I.. -Wall -Wextra -pedantic -O2'
    RESULT=$?
    if [ $RESULT -ne 0 ]; then
        echo ' the MAKE command failed with return code of ' $RESULT
        read -t 1 -n 10000 discard
        read -p "Press any key to continue... " -n1 -s
        exit 910
    fi
    cp pdcurses.dll pdcurses-wingui.dll
    ls *.dll
    install pdcurses*.dll /mingw32/bin/.
    install pdcurses.a /mingw32/lib/libpdcurses.a
#
#  ---> now repeat for WINCON
#
    cd $X32
    cd pdc*/wincon      # note changes
    make -j$cpu_count -f Makefile INFOEX=Y CHTYPE_64=Y DLL=Y CFLAGS='-I.. -Wall -Wextra -pedantic -O2'
    RESULT=$?
    if [ $RESULT -ne 0 ]; then
        echo ' the MAKE command failed with return code of ' $RESULT
        read -t 1 -n 10000 discard
        read -p "Press any key to continue... " -n1 -s
        exit 920
    fi
    cp pdcurses.dll pdcurses-wincon.dll
    ls *.dll
    install pdcurses*.dll /mingw32/bin/.
    install pdcurses.a /mingw32/lib/libpdcurses.a
#
#  first we need to prepend the following 4 lines to curses.h
#
    cd ..
    echo "/* defines matching the creation of the library */ " >  temp.txt
    echo "/* Arnold J. Trembley, 2022-05-29-Sun           */ " >> temp.txt
    echo "#define CHTYPE_64                                  " >> temp.txt
    echo "#define PDC_DLL_BUILD                              " >> temp.txt
    cat  curses.h                                              >> temp.txt
#
    cp temp.txt curses.h
#
#  display the contents of curses.h to ensure that it is correct.
#
    head curses.h
    tail curses.h
    cp curses.h pdcurses.h
    install *.h /mingw32/include/.
#
    echo " Done installing PDCursesMOD-4.3.4 !! "
#
}

#
# ==> this function builds Berkeley DB 18.1.40 from the most current
#     source code.
#
300_build_berkeley_db () {
    cd $X32
    if test -d "db-18.1.40" ; then
        echo ' the BDB directory exists '
        return
    fi

# ----> first remove existing directory for HOME
    rm -f -r  db*
    wget --no-check-certificate https://download.oracle.com/berkeley-db/db-18.1.40.tar.gz
    RESULT=$?
    if [ $RESULT -ne 0 ]; then
        echo ' the wget --no-check-certificate command failed with return code of ' $RESULT
        read -t 1 -n 10000 discard
        read -p "Press any key to continue... " -n1 -s
        exit 920
    fi
    tar xzf db*.tar.gz
    rm db*.tar.gz
    cd db*/src/os_windows
    cp os_stat.c os_stat.bak
    sed -i 's/_tcsclen/strlen/' os_stat.c
#
    cd $X32
    cd db*/build_unix
    ../dist/configure --enable-mingw --prefix=/mingw32 --enable-compat185 --with-mutex=x86/gcc-assembly --with-cryptography=no --enable-sql --enable-sql_compat
    RESULT=$?
    if [ $RESULT -ne 0 ]; then
        echo ' the CONFIGURE command failed with return code of ' $RESULT
        read -t 1 -n 10000 discard
        read -p "Press any key to continue... " -n1 -s
        exit 920
    fi
    make -j$cpu_count
    RESULT=$?
    if [ $RESULT -ne 0 ]; then
        echo ' the MAKE command failed with return code of ' $RESULT
        read -t 1 -n 10000 discard
        read -p "Press any key to continue... " -n1 -s
        exit 920
    fi
    make install
    RESULT=$?
    if [ $RESULT -gt 2 ]; then
        echo ' the MAKE INSTALL command failed with return code of ' $RESULT
        read -t 1 -n 10000 discard
        read -p "Press any key to continue... " -n1 -s
        exit 920
    fi
    ls /mingw32/bin/libdb*.dll
#
    echo " Done installing Berkeley DB 18.1 !! "
#
}

#
# ==> this function either installs or uninstalls the Berkeley DB 18.1.40
#     from the mingw32 directory
#
310_install_berkeley_db () {
    cd $X32
    cd db*/build_unix
    if [ "$1" == "install" ]; then
        make install
        RESULT=$?
        echo -n ' the MAKE INSTALL command ended with return code of '
        echo $RESULT
    else
        make uninstall
        RESULT=$?
        echo ' the MAKE UNINSTALL command ended with return code of ' $RESULT
        ls /mingw32/bin/libdb*.dll
        rm -f /mingw32/bin/libdb*.dll
        ls /mingw32/bin/libdb*.dll
    fi
#
    echo " Done installing Berkeley DB 18.1 !! "
#
}

#
#
# ==> this function builds VBISAM 2.1.1 from Ron Normans website
#
350_build_vbisam_db () {
    cd $X32
    if test -d "vbisam-2.1.1" ; then
        echo ' the VBISAM-2.1.1 directory exists '
        return
    fi

# ----> first remove existing directory for HOME
    rm -f -r  vbi*
    wget --no-check-certificate https://www.arnoldtrembley.com/vbisam-2.1.1-ChuckH.7z
    7z x  vbisam-2.1.1-ChuckH.7z
    rm vbisam-2.1.1-ChuckH.7z
    cd vbisam*
    ./configure --prefix=/mingw32 --disable-static --enable-shared --with-compatcisam
    RESULT=$?
    if [ $RESULT -ne 0 ]; then
        echo ' the CONFIGURE command failed with return code of ' $RESULT
        read -t 1 -n 10000 discard
        read -p "Press any key to continue... " -n1 -s
        exit 920
    fi
    make -j$cpu_count
    RESULT=$?
    if [ $RESULT -ne 0 ]; then
        echo ' the MAKE command failed with return code of ' $RESULT
        read -t 1 -n 10000 discard
        read -p "Press any key to continue... " -n1 -s
        exit 920
    fi
    cd tests
    .libs/detest01_ltshwrapper detest00
    .libs/jvntest_ltshwrapper
    .libs/mvtest2_ltshwrapper create
    .libs/mvtest2_ltshwrapper 2
    .libs/mvtest_ltshwrapper create
    .libs/mvtest_ltshwrapper 2
    cd ..
    make  install
    RESULT=$?
    if [ $RESULT -ne 0 ]; then
        echo ' the MAKE INSTALL command failed with return code of ' $RESULT
        read -t 1 -n 10000 discard
        read -p "Press any key to continue... " -n1 -s
        exit 920
    fi
    ls /mingw32/bin/libvbi*.dll
#
    echo " Done installing VBISAM 2.1.1   !! "
#
}


#
#
# ==> this function installs / uninstalls VBISAM 2.1.1
#     from the mingw32 directory
#
360_install_vbisam_db () {
    cd $X32
    cd vbisam*
    if [ "$1" == "install" ]; then
        make  install
        RESULT=$?
        echo 'the MAKE INSTALL command ended with return code of ' $RESULT
        return
    fi

        make  uninstall
        RESULT=$?
        echo 'the MAKE UNINSTALL command ended with return code of ' $RESULT
#
}


#
# ==> this function builds GNUCOBOL 3.2dev from the most current
#     source code.
#
400_build_gnucobol () {
    cd $X32
# ----> first remove existing directory for HOME
    if [ "$BUILD" == "yes" ]; then
        while ! rm -f -r  gnu* ;
        do
            echo 'rm gnucobol failed, sleeping for 5 seconds'
            sleep 5
            echo 'retrying...'
        done
        svn $svn_checkout $svn_gnucobol
        RESULT=$?
        if [ $RESULT -ne 0 ]; then
            echo ' the SVN command failed with return code of ' $RESULT
            read -t 1 -n 10000 discard
            read -p "Press any key to continue... " -n1 -s
            exit 910
        fi
        cd gnu*
        sed -i 's/AM_GNU_GETTEXT_VERSION/AM_GNU_GETTEXT_REQUIRE_VERSION/' configure.ac
        cd libcob
#       cp -f /C/msys64prep/patches/numeric.c  .
#       cp -f /C/msys64prep/patches/move.c     .
#       cp -f /C/msys64prep/patches/termio.c   .
#       cp -f /C/msys64prep/patches/mlio.c     .
        cd $X32
        cd gnu*
        cd tests/cobol85
        wget --no-check-certificate https://sourceforge.net/projects/gnucobol/files/nist/newcob.val.tar.gz
        RESULT=$?
        if [ $RESULT -ne 0 ]; then
            echo ' the wget --no-check-certificate command failed with return code of ' $RESULT
            read -t 1 -n 10000 discard
            read -p "Press any key to continue... " -n1 -s
            exit 910
        fi
        tar xzf newcob.val.tar.gz
        rm newcob.val.tar.gz
        cd $X32
        cd gnu*
        ./autogen.sh install
    fi

    cd $X32
    cd gnu*
    export lt_cv_deplibs_check_method=${lt_cv_deplibs_check_method='pass_all'}
    if [ "$ISAM" == "--with-db-old" ]; then
        ./configure -prefix=/mingw32               \
                --with-db                          \
                --disable-rpath                    \
                --with-curses=pdcurses             \
                PERL=/usr/bin/perl                 \
                CFLAGS='-O2'  \
                CPPLAGS="-D__USE_MINGW_ANSI_STDIO=1"
#               --enable-debug
#               --enable-code-coverage
    else
        ./configure -prefix=/mingw32               \
                $ISAM                              \
                --disable-rpath                    \
                --with-curses=pdcurses             \
                PERL=/usr/bin/perl                 \
                CFLAGS='-O2'  \
                CPPLAGS="-D__USE_MINGW_ANSI_STDIO=1"
#               --enable-debug
#               --enable-code-coverage
    fi
    RESULT=$?
    if [ $RESULT -ne 0 ]; then
        echo ' the CONFIGURE command failed with return code of ' $RESULT
        read -t 1 -n 10000 discard
        read -p "Press any key to continue... " -n1 -s
        exit 910
    fi
    make -j$cpu_count                                               # Build the GnuCOBOL compiler
    RESULT=$?
    if [ $RESULT -ne 0 ]; then
        echo ' the MAKE command failed with return code of ' $RESULT
        read -t 1 -n 10000 discard
        read -p "Press any key to continue... " -n1 -s
        exit 910
    fi
    make -j$cpu_count dist -C po                                    # Build translations

    if [ "$BUILD" == "yes" ]; then
        make check TESTSUITEFLAGS="--jobs=$cpu_count"                   # Test the GnuCOBOL build
        make -j$cpu_count test PERL=/usr/bin/perl  COB_UNIX_LF=Y        # Run NIST COBOL 85 test suite
    fi

    make install                                                    # Prepare Install format
    RESULT=$?
    if [ $RESULT -ne 0 ]; then
        echo ' the MAKE INSTALL command failed with return code of ' $RESULT
        read -t 1 -n 10000 discard
        read -p "Press any key to continue... " -n1 -s
        exit 910
    fi
#
    echo " Done installing GNUCOBOL 3.2dev !! "
#
}

#
# ==> this function builds GCSORT from the most current
#     source code.
#
500_build_gcsort   () {
    cd $X32
# ----> first remove existing directory for HOME
    while ! rm -f -r  gcsort* ;
    do
        echo 'rm gcsort failed, sleeping for 5 seconds'
        sleep 5
        echo 'retrying...'
    done
    svn $svn_checkout $svn_gcsort
    RESULT=$?
    if [ $RESULT -ne 0 ]; then
        echo ' the SVN command failed with return code of ' $RESULT
        read -t 1 -n 10000 discard
        read -p "Press any key to continue... " -n1 -s
        exit 910
    fi
    cd gcsort*

#
    wget --no-check-certificate https://www.arnoldtrembley.com/cobenv.zip
    RESULT=$?
    if [ $RESULT -ne 0 ]; then
        echo ' the wget --no-check-certificate command failed with return code of ' $RESULT
        read -t 1 -n 10000 discard
        read -p "Press any key to continue... " -n1 -s
        exit 910
    fi
    unzip -o cobenv.zip -d /mingw32/bin
    rm -f -r  cobenv.zip
# ====>>>> setup cobol environment
    source cobenv.sh --setenv
    cobc --info
    cobcrun --info
#
    cd $X32
    cd gcsort*
    make -j$cpu_count CCFLAGS='-fkeep-inline-functions -O2'
    RESULT=$?
    if [ $RESULT -ne 0 ]; then
        echo ' the MAKE command failed with return code of ' $RESULT
        read -t 1 -n 10000 discard
        read -p "Press any key to continue... " -n1 -s
        exit 910
    fi
    ./gcsort.exe --version
    cp gcsort.exe  /mingw32/bin
    cd tests/script/
    ./compile.sh
    cd $X32
    cd gcsort*
    cd tests/bin
    ls -l
    export COB_PRE_LOAD=gctestgetop.so
    for varname in ${!COB*};
        do      echo $varname is ${!varname} ;
    done
    ./gctestset.exe
    ls -l
    ./gctestrun 1>log_run.log 2>log_run_err.log
    tail log_run.log -n 20
#
# ====> copy gcsort.exe to the gnucobol distribution folders...
#
#   cd $HOME/x32/gnu*
#   cp  /mingw32/bin/gcsort.exe  GnuCOBOL_mingw/bin
#   cp  /mingw32/bin/gcsort.exe  GnuCOBOL_mingw_dbg/bin
#
echo " Done installing GCSORT !! "
#
}

#
# ==> this function builds cbl_gdb from the current source
#     source code.
#
600_build_cbl_gdb () {
    cd $X32
# ----> first remove existing directory for HOME
    rm -f -r  cbl-gdb*
    wget --no-check-certificate https://gitlab.cobolworx.com/COBOLworx/cbl-gdb/-/archive/Version4.28.6/cbl-gdb-Version4.28.6.tar.gz
    RESULT=$?
    if [ $RESULT -ne 0 ]; then
        echo ' the wget --no-check-certificate command failed with return code of ' $RESULT
        read -t 1 -n 10000 discard
        read -p "Press any key to continue... " -n1 -s
        exit 910
    fi
    tar xzf cbl*.tar.gz
    rm cbl*.tar.gz
    cd cbl*
    cd cobcd-sfix
    sed -i '37i #include <cstdint>' utils.h
#   cp -f /F/GNUCOBOL_SOURCE/utils.h  .
#   cp -f /F/GNUCOBOL_SOURCE/sfix.cpp .
    cd ..
    make -j$cpu_count all
    RESULT=$?
    if [ $RESULT -ne 0 ]; then
        echo ' the MAKE command failed with return code of ' $RESULT
        read -t 1 -n 10000 discard
        read -p "Press any key to continue... " -n1 -s
        exit 910
    fi
    make -j$cpu_count prefix=/mingw32 install
    RESULT=$?
    if [ $RESULT -ne 0 ]; then
        echo ' the MAKE INSTALL command failed with return code of ' $RESULT
        read -t 1 -n 10000 discard
        read -p "Press any key to continue... " -n1 -s
        exit 910
    fi
    make .gdbinit prefix=/mingw32
#
    echo " Done installing CBL-GDB !!! "
#
}


#
# ==> this function builds gnucobol distribution files.
#     source code.
#
700_build_distmingw ()  {
    cd $X32
    cd gnu*
    rm -f -r GnuCOBOL_mingw
    rm -f -r GnuCOBOL_mingw_dbg
    cd build_aux
    grep duplicating create_mingw_bindist.sh -B 9999 | head -n -1 > my_bindist.sh
    grep -i finished create_mingw_bindist.sh -A 9999 >> my_bindist.sh
    mv create_mingw_bindist.sh  create_mingw_bindist_original.sh
    mv my_bindist.sh            create_mingw_bindist.sh
    cd ..
    make distmingw
    RESULT=$?
    if [ $RESULT -ne 0 ]; then
        echo ' the MAKE DISTMINGW failed with return code of ' $RESULT
        read -t 1 -n 10000 discard
        read -p "Press any key to continue... " -n1 -s
        exit 910
    fi
    cd GnuCOBOL_mingw
    curl -Lko gnucobol.pdf "https://gnucobol.sourceforge.io/doc/gnucobol.pdf"
    RESULT=$?
    if [ $RESULT -ne 0 ]; then
        echo ' the CURL failed with return code of ' $RESULT
        read -t 1 -n 10000 discard
        read -p "Press any key to continue... " -n1 -s
        exit 910
    fi
    wget --no-check-certificate --output-document=gnucobolpg.pdf \
        https://sourceforge.net/p/gnucobol/code/HEAD/tree/external-doc/guide/PDFs/gnucobpg-letter.pdf?format=raw
    RESULT=$?
    if [ $RESULT -ne 0 ]; then
        echo ' the wget --no-check-certificate failed with return code of ' $RESULT
        read -t 1 -n 10000 discard
        read -p "Press any key to continue... " -n1 -s
        exit 910
    fi
    rm bin/cobenv.*
    rm bin/build*.sh
    cd ..

    if [ "$ISAM" == "--with-vbisam" ]; then
        mv GnuCOBOL_mingw  GNUCOBOL-X32-VBISAM
        7z a -r -mx9 GNUCOBOL-X32-VBISAM   ./GNUCOBOL-X32-VBISAM/*
        rm -f -r GNUCOBOL-X32-VBISAM
    fi

    if [ "$ISAM" == "--with-db" ]; then
        mv GnuCOBOL_mingw  GNUCOBOL-X32-BDB
        7z a -r -mx9 GNUCOBOL-X32-BDB   ./GNUCOBOL-X32-BDB/*
        rm -f -r GNUCOBOL-X32-BDB
    fi

    if [ "$ISAM" == "--without-db" ]; then
        mv GnuCOBOL_mingw  GNUCOBOL-X32-NODB
        7z a -r -mx9 GNUCOBOL-X32-NODB   ./GNUCOBOL-X32-NODB/*
        rm -f -r GNUCOBOL-X32-NODB
    fi

    if [ "$ISAM" == "--with-db-old" ]; then
        mv GnuCOBOL_mingw  GNUCOBOL-X32-BDB-OLD
        7z a -r -mx9 GNUCOBOL-X32-BDB-OLD   ./GNUCOBOL-X32-BDB-OLD/*
        rm -f -r GNUCOBOL-X32-BDB-OLD
    fi

    echo " Done installing MINGW DISTRIBUTION FILES !!! "
#
}


#   call function to build toolchain dependencies
    start_time=$(date)
    echo "@@start time      $start_time"
#
#       call function to build pdcursesmod
    200_build_pdcurses
    pdcurses_time=$(date)
    echo "@@pdcurses        $pdcurses_time"
#
#       call function to build berkeley db
    300_build_berkeley_db
    berkeley_time=$(date)
    echo "@@berkeley        $berkeley_time"
#
#       call function to build vbisam-2.1.1
    350_build_vbisam_db
    vbisam_time=$(date)
    echo "@@vbisam          $vbisam_time"
#
#       check to see if Berkeley needs to be installed or uninstalled

    echo ' ISAM ==> ' $ISAM

    if [ "$ISAM" == "--with-db" ]; then
        310_install_berkeley_db "install"
    else
        310_install_berkeley_db "uninstall"
    fi

#
#       check to see if VBISAM needs to be installed or uninstalled

    echo ' ISAM ==> ' $ISAM

    if [ "$ISAM" == "--with-vbisam" ]; then
        360_install_vbisam_db "install"
    else
        360_install_vbisam_db "uninstall"
    fi

#
#       check to see if Berkeley 6.0.19 to be installed or uninstalled

    echo ' ISAM ==> ' $ISAM

    if [ "$ISAM" == "--with-db-old" ]; then
        pacman -S --noconfirm  mingw-w64-i686-db
        RESULT=$?
        if [ $RESULT -ne 0 ]; then
            echo ' the PACMAN -S failed with return code of ' $RESULT
            read -t 1 -n 10000 discard
            read -p "Press any key to continue... " -n1 -s
#           exit 910
        fi
    else
        pacman -Rs --noconfirm  mingw-w64-i686-db
        RESULT=$?
        if [ $RESULT -gt 1 ]; then
            echo ' the PACMAN -Rs failed with return code of ' $RESULT
            read -t 1 -n 10000 discard
            read -p "Press any key to continue... " -n1 -s
#           exit 910
        fi
    fi

#
#       call function to build gnucobol
    400_build_gnucobol
    gnucobol_time=$(date)
    echo "@@gnucobol        $gnucobol_time"
#
#       call function to build gcsort
    500_build_gcsort
    gcsort_time=$(date)
    echo "@@gcsort          $gcsort_time"
#
#       call function to build cbl-gdb
    600_build_cbl_gdb
    cbl_gdb_time=$(date)
    echo "@@cbl_gdb_time    $cbl_gdb_time"
#
#       call function to build MINGW DISTRIBUTION FILES
    700_build_distmingw
    distmingw_time=$(date)
    echo "@@distmingwtime   $distmingw_time"

    echo "@@start time      $start_time"
    echo "@@toolchain       $toolchain_time"
    echo "@@pdcurses        $pdcurses_time"
    echo "@@berkeley        $berkeley_time"
    echo "@@vbisam          $vbisam_time"
    echo "@@gnucobol        $gnucobol_time"
    echo "@@gcsort          $gcsort_time"


    echo "@@start time      $start_time"        >  $X32/runtime.txt
    echo "@@toolchain       $toolchain_time"    >> $X32/runtime.txt
    echo "@@pdcurses        $pdcurses_time"     >> $X32/runtime.txt
    echo "@@berkeley        $berkeley_time"     >> $X32/runtime.txt
    echo "@@vbisam          $vbisam_time"       >> $X32/runtime.txt
    echo "@@gnucobol        $gnucobol_time"     >> $X32/runtime.txt
    echo "@@gcsort          $gcsort_time"       >> $X32/runtime.txt
    echo "@@cbl_gdb_time    $cbl_gdb_time"      >> $X32/runtime.txt
    echo "@@distmingwtime   $distmingw_time"    >> $X32/runtime.txt

